libname q 'c:\SASCodeforBook\SASDataSets';
	/*This SAS code provides the information paralling that in Figure 12.3 through 
	Figure 12.6.The Difference in Differences Estimators are calculated using KR corrections*/

Data first; set q.HoustonSchools;


/*This code standardizes the covariates to mean zero*/

Title 'This codes standardizes the covariates by their mean';
   Proc standard data = first out= standard mean=0;
   var gpropensity3 sfal 
	higraddm frrdprob stratio mobility hispprob
	femprob maleprob blackprob lep;
Run;

Title 'This code provides a check that the means are zero';
   proc means data = standard;
   var gpropensity3 sfal 
    higraddm frrdprob stratio mobility hispprob
	femprob maleprob blackprob lep; 
run;

data standard; set standard;

 /* The following code presents the difference in differences estimators for Figure 12.3
	through Figure 12.6 if the KR correction were made.  For reading, mathematics, the average 
	of reading and matematics, and fourth grade writing.  The nuanced covariance structures 
	are used in the models. */	

Title 'KR Reading DID Effects, CS December 2010, Full Model, paralleling Figure 12.3';
Proc Glimmix data = standard  method = rspl  ic=pq noitprint ;
	Class school treatment period; 
	Model reading/denom = treatment period treatment*period 
	sfal Gpropensity3
	higraddm frrdprob stratio  mobility Hispprob
 	/ cl solution dist=binomial link=logit ddfm=KenwardRoger;
	nloptions maxiter =50;
	random period / sub = school(treatment)  type = cs s residual vcorr;
	lsmeans  treatment*period / odds ilink cl ;
	lsmestimate treatment*period '(1,1-1,0) versus (0,1 - 0,0)'
		1 -1 0  -1 1 0 /or ilink cl; 
Title2 'Difference in differences estimator for first two time periods';
	*for the target group this estimates the difference between the means;
	estimate '1,1 - 1,0' period -1 1 0  treatment*period 0 0 0 -1 1 0 /or ilink cl;   
	*for the comparison group this estimates the difference between the means;
	estimate '0,1 - 0,0' period -1 1 0  treatment*period -1 1 0/or ilink cl;
	*this estimates the difference between the differences;
	estimate '(1,1-1,0) versus (0,1 - 0,0)' treatment*period 1 -1 0   -1 1 0 /or ilink cl;
Title3 'Difference in differences estimator for the third time period relative to the first';
	*for the target group this estimates the difference between the means;
	estimate '1,2 - 1,0' period -1 0 1  treatment*period 0 0 0 -1 0 1 /or ilink cl; 
	*this  gets the difference between means for the third time period relative to the first, null treatment;
	estimate '0,2 - 0,0' period -1 0 1  treatment*period -1 0 1 /or ilink cl; 
	*this estimates the difference between the two differences above;
	estimate '(1,2 - 1,0) versus (0,2 - 0,0)' treatment*period 1 0 -1 -1 0 1/or ilink cl; 
Title4 'Difference in differences estimator for the third time period relative to the second';
	*for the target group this estimates the difference between the means;
	estimate '1,2 - 1,1' period 0 -1  1  treatment*period 0 0 0   0 -1  1 /or ilink cl;  
	*this gets the difference between means for the third time period relative to the second, null group;
	estimate '0,2 - 0,1' period 0 -1  1  treatment*period 0 -1  1 /or ilink cl;  
	*this estimates the difference between the two differences above;
	estimate '(1,2 - 1,1) versus (0,2 - 0,1)' treatment*period 0 1 -1  0 -1  1 /or ilink cl; 
run;
		
Title 'KR Math DID Effects, Toeplitz (2) December 2010, paralleling Figure 12.4';
	Proc Glimmix data = standard  method = rspl  ic=pq noitprint;
	Class school treatment period;
	Model Math/denom = treatment period treatment*period  sfal gpropensity3
	higraddm frrdprob stratio mobility Hispprob
	/ cl solution dist=binomial link=logit ddfm = kenwoodroger;
	nloptions maxiter =20;
	random period / sub = school (treatment) type = toep(2) s residual vcorr;
	lsmeans  treatment*period / odds ilink cl ;
	lsmestimate treatment*period '(1,1-1,0) versus (0,1 - 0,0)'
		1 -1 0  -1 1 0 /or ilink cl;
Title2 'Difference in differences estimator for first two time periods';
	*for the target group this estimates the difference between the means;
	estimate '1,1 - 1,0' period -1 1 0  treatment*period 0 0 0 -1 1 0 /or ilink cl;   
	*for the comparison group this estimates the difference between the means;
	estimate '0,1 - 0,0' period -1 1 0  treatment*period -1 1 0/or ilink cl;
	*this estimates the difference between the differences;
	estimate '(1,1-1,0) versus (0,1 - 0,0)' treatment*period 1 -1 0   -1 1 0 /or ilink cl;
Title3 'Difference in differences estimator for the third time period relative to the first';
	*for the target group this estimates the difference between the means;
	estimate '1,2 - 1,0' period -1 0 1  treatment*period 0 0 0 -1 0 1 /or ilink cl; 
	*this  gets the difference between means for the third time period relative to the first, null treatment;
	estimate '0,2 - 0,0' period -1 0 1  treatment*period -1 0 1 /or ilink cl; 
	*this estimates the difference between the two differences above;
	estimate '(1,2 - 1,0) versus (0,2 - 0,0)' treatment*period 1 0 -1 -1 0 1/or ilink cl; 
Title4 'Difference in differences estimator for the third time period relative to the second';
	*for the target group this estimates the difference between the means;
	estimate '1,2 - 1,1' period 0 -1  1  treatment*period 0 0 0   0 -1  1 /or ilink cl;  
	*this gets the difference between means for the third time period relative to the second, null group;
	estimate '0,2 - 0,1' period 0 -1  1  treatment*period 0 -1  1 /or ilink cl;  
	*this estimates the difference between the two differences above;
	estimate '(1,2 - 1,1) versus (0,2 - 0,1)' treatment*period 0 1 -1  0 -1  1 /or ilink cl; 
run;

Title 'KR Ave.Math and Reading DID Effects, CS December2010, Paralleling Figure 9.5';
Proc Glimmix data = standard  method = rspl  ic=pq noitprint;
	Class school treatment period;
	Model avemard/denom = treatment period treatment*period  gpropensity3 sfal
	higraddm frrdprob stratio mobility Hispprob
	/ cl solution dist=binomial link=logit ddfm=kenwoodroger;
	nloptions maxiter =20;
	random period / sub = school(treatment)  type = cs residual vcorr;
	lsmeans  treatment*period / odds ilink cl ;
	lsmestimate treatment*period '(1,1-1,0) versus (0,1 - 0,0)'
		1 -1 0  -1 1 0 /or ilink cl;
Title2 'Difference in differences estimator for first two time periods';
	*for the target group this estimates the difference between the means;
	estimate '1,1 - 1,0' period -1 1 0  treatment*period 0 0 0 -1 1 0 /or ilink cl;   
	*for the comparison group this estimates the difference between the means;
	estimate '0,1 - 0,0' period -1 1 0  treatment*period -1 1 0/or ilink cl;
	*this estimates the difference between the differences;
	estimate '(1,1-1,0) versus (0,1 - 0,0)' treatment*period 1 -1 0   -1 1 0 /or ilink cl;
Title3 'Difference in differences estimator for the third time period relative to the first';
	*for the target group this estimates the difference between the means;
	estimate '1,2 - 1,0' period -1 0 1  treatment*period 0 0 0 -1 0 1 /or ilink cl; 
	*this  gets the difference between means for the third time period relative to the first, null treatment;
	estimate '0,2 - 0,0' period -1 0 1  treatment*period -1 0 1 /or ilink cl; 
	*this estimates the difference between the two differences above;
	estimate '(1,2 - 1,0) versus (0,2 - 0,0)' treatment*period 1 0 -1 -1 0 1/or ilink cl; 
Title4 'Difference in differences estimator for the third time period relative to the second';
	*for the target group this estimates the difference between the means;
	estimate '1,2 - 1,1' period 0 -1  1  treatment*period 0 0 0   0 -1  1 /or ilink cl;  
	*this gets the difference between means for the third time period relative to the second, null group;
	estimate '0,2 - 0,1' period 0 -1  1  treatment*period 0 -1  1 /or ilink cl;  
	*this estimates the difference between the two differences above;
	estimate '(1,2 - 1,1) versus (0,2 - 0,1)' treatment*period 0 1 -1  0 -1  1 /or ilink cl; 
run;

Title'KR G4Writing DID Effects, UN(1)Banded Main Diagonal,December 2010, Paralleing Figure 9.6';
Proc Glimmix data = standard  method = rspl  ic=pq noitprint;
	Class school treatment period; 
	Model g4write/denom = treatment period treatment*period
	sfal Gpropensity3
	higraddm frrdprob stratio  mobility Hispprob
	/ cl solution dist=binomial link=logit ddfm=kenwoodroger;
	nloptions maxiter =30;
	random period / sub = school(treatment)  type = un(1) s residual vcorr;
		lsmeans  treatment*period / odds ilink cl ;
	lsmestimate treatment*period '(1,1-1,0) versus (0,1 - 0,0)'
		1 -1 0  -1 1 0 /or ilink cl;
Title2 'Difference in differences estimator for first two time periods';
	*for the target group this estimates the difference between the means;
	estimate '1,1 - 1,0' period -1 1 0  treatment*period 0 0 0 -1 1 0 /or ilink cl;   
	*for the comparison group this estimates the difference between the means;
	estimate '0,1 - 0,0' period -1 1 0  treatment*period -1 1 0/or ilink cl;
	*this estimates the difference between the differences;
	estimate '(1,1-1,0) versus (0,1 - 0,0)' treatment*period 1 -1 0   -1 1 0 /or ilink cl;
Title3 'Difference in differences estimator for the third time period relative to the first';
	*for the target group this estimates the difference between the means;
	estimate '1,2 - 1,0' period -1 0 1  treatment*period 0 0 0 -1 0 1 /or ilink cl; 
	*this  gets the difference between means for the third time period relative to the first, null treatment;
	estimate '0,2 - 0,0' period -1 0 1  treatment*period -1 0 1 /or ilink cl; 
	*this estimates the difference between the two differences above;
	estimate '(1,2 - 1,0) versus (0,2 - 0,0)' treatment*period 1 0 -1 -1 0 1/or ilink cl; 
Title4 'Difference in differences estimator for the third time period relative to the second';
	*for the target group this estimates the difference between the means;
	estimate '1,2 - 1,1' period 0 -1  1  treatment*period 0 0 0   0 -1  1 /or ilink cl;  
	*this gets the difference between means for the third time period relative to the second, null group;
	estimate '0,2 - 0,1' period 0 -1  1  treatment*period 0 -1  1 /or ilink cl;  
	*this estimates the difference between the two differences above;
	estimate '(1,2 - 1,1) versus (0,2 - 0,1)' treatment*period 0 1 -1  0 -1  1 /or ilink cl; 
run;


/* This completes the code for Figures 12.3 to 12.6 using KR corrections*/
/* The syntax in this file is copyright by Robert B. Smith,  2011 */














































 
